---
title: Overview · Cloudflare Aegis docs
description: Cloudflare Aegis provides dedicated egress IPs (from Cloudflare to
  your origin) for your layer 7 WAF and CDN services, as well as Spectrum. The
  egress IPs are reserved exclusively for your account so that you can increase
  your origin security by only allowing traffic from a small list of IP
  addresses.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/aegis/
  md: https://developers.cloudflare.com/aegis/index.md
---

Leverage dedicated IPs to improve your origin security and implement Zero Trust.

Enterprise-only

Cloudflare Aegis provides dedicated egress IPs (from Cloudflare to your origin) for your layer 7 [WAF](https://developers.cloudflare.com/waf/) and CDN services, as well as [Spectrum](https://developers.cloudflare.com/spectrum/). The egress IPs are reserved exclusively for your account so that you can increase your origin security by only allowing traffic from a small list of IP addresses.

Both [BYOIP](https://developers.cloudflare.com/byoip) and Cloudflare-leased IPs are supported by Cloudflare Aegis.

Availability

Cloudflare Aegis is available in early access to Enterprise customers. Contact your account team to request access.

***

## Related products

**[Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)**

Cloudflare Access determines who can reach your application by applying the Access policies you configure.

**[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)**

Cloudflare Tunnel provides you with a secure way to connect your resources to Cloudflare without a publicly routable IP address.

**[Authenticated Origin Pulls](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/)**

Authenticated Origin Pulls gives you the ability to perform mutual TLS between Cloudflare and your origin environment, providing cryptographically verifiable proof of the source of the traffic you receive.

***

## More resources

[Introductory blog post](https://blog.cloudflare.com/cloudflare-aegis/)

Deep dive into use cases where Aegis can help secure enterprise origins.

[Multi-Vendor Architecture](https://developers.cloudflare.com/reference-architecture/architectures/multi-vendor/#connectivity-options)

Reference Architecture for multi-vendor application security and performance.
