---
title: Deliver emails to the junk email folder - Office 365 · Cloudflare Email
  security (formerly Area 1) docs
description: In this tutorial, you will learn to deliver SUSPICIOUS and BULK
  messages to the user's junk email folder, and MALICIOUS, SPAM, and SPOOF
  messages to the Administrative Quarantine (this requires an administrator to
  release the emails).
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/deployment/inline/setup/office-365-area1-mx/use-cases/five-junk-admin-quarantine/
  md: https://developers.cloudflare.com/email-security/deployment/inline/setup/office-365-area1-mx/use-cases/five-junk-admin-quarantine/index.md
---

In this tutorial, you will learn to deliver `SUSPICIOUS` and `BULK` messages to the user's junk email folder, and `MALICIOUS`, `SPAM`, and `SPOOF` messages to the Administrative Quarantine (this requires an administrator to release the emails).

## Configure domains

You first need to configure the domains you are onboarding on the Email Security (formerly Area 1) dashboard. To configure your domains:

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).

2. Go to **Settings** (the gear icon).

3. Go to **Email configuration** > **Domains & Routing** > **Domains**.

4. Make sure each domain you are onboarding has been added.

5. For each domain you are configuring, select **...** > **Edit**, and set the following options:

   * **Domain** - `<YOUR_DOMAIN>`.
   * **Configured as** - `MX Records`.
   * **Forwarding to** - This should match the expected MX record for each domain in your [Office 365 account](https://admin.microsoft.com/#/Domains/).
   * **IP Restrictions** - Leave this field empty.
   * **Outbound TLS** - `Forward all messages over TLS`.
   * **Quarantine Policy** - Do not check any dispositions.

## Configure anti-spam policies

To configure anti-spam policies:

1. Open the [Microsoft 365 Defender console](https://security.microsoft.com/).

2. Go to **Email & collaboration** > **Policies & rules**.

3. Select **Threat policies**.

4. Under **Policies**, select **Anti-spam**.

5. Select the **Anti-spam inbound policy (Default)** text (not the checkbox).

6. In **Actions**, scroll down and select **Edit actions**.

   ![Go to Actions and find Edit actions](https://developers.cloudflare.com/_astro/step6-edit-actions.T4_p91g__FX92f.webp)

7. Set the following conditions and actions (you might need to scroll up or down to find them):

* **Spam**: *Move messages to Junk Email folder*.

* **High confidence spam**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.

* **Phishing**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.

* **High confidence phishing**: *Quarantine message*.
  * **Select quarantine policy**: \_AdminOnlyAccessPolicy\_.

* **Retain spam in quarantine for this many days**: Default is 15 days. Email Security (formerly Area 1) recommends 15-30 days.

  * Select the spam actions in the above step:

    ![Select the spam actions in the above step](https://developers.cloudflare.com/_astro/case2-step7-spam.DSFGImyT_2jgw9V.webp)

1. Select **Save**.

## Create transport rules

To create the transport rules that will send emails with certain dispositions to Email Security:

1. Open the new [Exchange admin center](https://admin.exchange.microsoft.com/#/homepage).

2. Go to **Mail flow** > **Rules**.

3. Select **Add a Rule** > **Create a new rule**.

4. Set the following rule conditions:

   * **Name**: *Email security Deliver to Junk Email folder\`*.

   * **Apply this rule if**: *The message headers* > *includes any of these words*.

     * **Enter text**: `X-Area1Security-Disposition` > **Save**.
     * **Enter words**: `` `SUSPICIOUS`, `BULK` `` > **Add** > **Save**.

   * **Apply this rule if**: Select **+** to add a second condition.

   * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs page](https://developers.cloudflare.com/email-security/deployment/inline/reference/egress-ips/).

   * **Do the following** - *\_Modify the message properties\_ > \_Set the Spam Confidence Level (SCL)\_ > \_5\_*.

1) Select **Next**.

2) You can use the default values on this screen. Select **Next**.

3) Review your settings and select **Finish** > **Done**.

4) Select the rule Email security Deliver to Junk Email folder\` you have just created, and **Enable**.

5) Select **Add a Rule** > **Create a new rule**.

6) Set the following rule conditions:

   * **Name**: *\`Area 1 Admin Managed Host Quarantine\`*.

   * **Apply this rule if**: *The message headers* > *includes any of these words*.

     * **Enter text**: `X-Area1Security-Disposition` > **Save**.
     * **Enter words**: *\`MALICIOUS\`, \`UCE\`, \`SPOOF\`* > **Add** > **Save**.

   * **Apply this rule if**: Select **+** to add a second condition.

   * **And**: *The sender* > *IP address is in any of these ranges or exactly matches* > enter the egress IPs in the [Egress IPs page](https://developers.cloudflare.com/email-security/deployment/inline/reference/egress-ips/).

   * **Do the following**: *\_Redirect the message to\_ > \_hosted quarantine\_*.

1. Select **Next**.

2. You can use the default values on this screen. Select **Next**.

3. Review your settings and select **Finish** > **Done**.

4. Select the rule *\`Area 1 Admin Managed Host Quarantine\`* you have just created, and select **Enable**.
