---
title: Define a single origin rule using Terraform · Cloudflare Rules docs
description: Create an origin rule using Terraform to override the `Host`
  header, the resolved hostname, and the destination port of API requests.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/origin-rules/examples/define-single-origin-terraform/
  md: https://developers.cloudflare.com/rules/origin-rules/examples/define-single-origin-terraform/index.md
---

Note

Terraform code snippets below refer to the v4 SDK only.

The following example defines a single origin rule for a zone using Terraform. The rule overrides the `Host` header, the resolved hostname, and the destination port of API requests.

```tf
# Change origin for API requests
resource "cloudflare_ruleset" "http_origin_example" {
  zone_id     = "<ZONE_ID>"
  name        = "Change origin"
  description = ""
  kind        = "zone"
  phase       = "http_request_origin"


  rules {
    ref         = "change_api_origin"
    description = "Change origin of API requests"
    expression  = "(http.request.uri.path matches \"^/api/\")"
    action      = "route"
    action_parameters {
      host_header = "example.net"
      origin {
        host = "example.net"
        port = 8000
      }
    }
  }
}
```

Use the `ref` field to get stable rule IDs across updates when using Terraform. Adding this field prevents Terraform from recreating the rule on changes. For more information, refer to [Troubleshooting](https://developers.cloudflare.com/terraform/troubleshooting/rule-id-changes/#how-to-keep-the-same-rule-id-between-modifications) in the Terraform documentation.

## Additional resources

For additional guidance on using Terraform with Cloudflare, refer to the following resources:

* [Terraform documentation](https://developers.cloudflare.com/terraform/)
* [Cloudflare Provider for Terraform](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) (reference documentation)
