---
title: Remove response headers · Cloudflare Rules docs
description: Remove from response all headers that start with a certain name.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/
  md: https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/index.md
---

```js
export default {
  async fetch(request) {
    // Define the prefix of the headers you want to remove
    const headerPrefix = "x-header-";


    // Receive response from the origin
    const response = await fetch(request);


    // Create a new Headers object to modify response headers
    const newHeaders = new Headers(response.headers);


    // Remove headers that start with the specified prefix
    for (const [key] of newHeaders.entries()) {
      if (key.startsWith(headerPrefix)) {
        newHeaders.delete(key);
      }
    }


    // Return the modified response with updated headers
    return new Response(response.body, {
      status: response.status,
      headers: newHeaders,
    });
  },
};
```
