---
title: Geo Key Manager · Cloudflare SSL/TLS docs
description: Geo Key Manager allows customers to store and manage the encryption
  keys for their domains in different geographic locations so they can meet
  compliance regulations and keep data secure.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/geokey-manager/
  md: https://developers.cloudflare.com/ssl/edge-certificates/geokey-manager/index.md
---

Restrict where the private keys used for TLS certificates are stored and managed.

Geo Key Manager allows customers to store and manage the encryption keys for their domains in different geographic locations so they can meet compliance regulations and keep data secure.

## Resources

* [Setup](https://developers.cloudflare.com/ssl/edge-certificates/geokey-manager/setup/)
* [Supported options](https://developers.cloudflare.com/ssl/edge-certificates/geokey-manager/supported-options/)

## Limitations

Currently, Geo Key Manager is limited to [custom certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) and available only through the Cloudflare API.

***

## Related products

**[Data Localization Suite](https://developers.cloudflare.com/data-localization/)**

The Data Localization Suite (DLS) is a set of products that helps customers who want to maintain local control over their traffic while retaining the security benefits of a global network.

**[Geo Key Manager (v1)](https://blog.cloudflare.com/introducing-cloudflare-geo-key-manager/)**

The first version of Geo Key Manager supports 3 regions: U.S., E.U., and a set of High Security Data Centers. If you would like to restrict your private key to another country or region, [apply for the closed beta](https://www.cloudflare.com/lp/geo-key-manager/) of the new version.

***

## More resources

[Plans](https://www.cloudflare.com/plans/#overview)

Compare available Cloudflare plans
